//**************************************************************************/
// Copyright (c) 2010 Autodesk, Inc.
// All rights reserved.
// 
// These coded instructions, statements, and computer programs contain
// unpublished proprietary information written by Autodesk, Inc., and are
// protected by Federal copyright law. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without
// the prior written consent of Autodesk, Inc.
//**************************************************************************/

// World-view-projection transformation.
float4x4 gWVPXf : WorldViewProjection < string UIWidget = "None"; >;

Texture2D gRGBTexture;
Texture2D gAlphaTexture;

SamplerState RGBSampler;
SamplerState AlphaSampler;

struct VS_INPUT
{
    float4 Pos : POSITION;
    float3 UV : TEXCOORD0;
};

// Vertex shader output structure.
struct VS_TO_PS
{
    float4 HPos : SV_POSITION;
    float3 UV : TEXCOORD0;
};

// Vertex shader.
VS_TO_PS VS_NPR(VS_INPUT In)
{
    VS_TO_PS Out;

    // Transform the position from object space to clip space for output.
    Out.HPos = mul(In.Pos, gWVPXf);

    // Pass the texture coordinates unchanged.
    Out.UV = In.UV;

    return Out;
}

// Pixel shader.
float4 PS_NPR(VS_TO_PS In) : SV_TARGET
{
    float4 rgb = gRGBTexture.Sample(RGBSampler, In.UV);
    float4 alpha = gAlphaTexture.Sample(AlphaSampler, In.UV);

    return float4(rgb.rgb, alpha.a);
}

// The main technique.
fxgroup dx10
{
technique10 Main_dx10
{
    pass p0
    {
        VertexShader = compile vs_4_0 VS_NPR();
		GeometryShader = NULL;
        PixelShader = compile ps_4_0 PS_NPR();
    }
}
}

// The main technique.
fxgroup dx11
{
technique11 Main_dx11
{
    pass p0
    {
        VertexShader = compile vs_5_0 VS_NPR();
		GeometryShader = NULL;
        PixelShader = compile ps_5_0 PS_NPR();
    }
}
}
